﻿#include  "StdAfx.h"

#include  <szCodecManager.hpp>
#include  <szRuntimeException.hpp>
#include  <7zip/UI/Common/LoadCodecs.h>

SZ_AN_BEG

szpp::CodecManager *sCodecManager = 0;

SZ_AN_END

SZ_NS_BEG(szpp)

void CodecManager::Shutdown()
{
  delete sCodecManager;
  sCodecManager = 0;
}

ArchiveExtractor *CodecManager::CreateExtractor(ArchiveVolume *volume, const ArchiveHandler *handler)
{
  const CCodecs * c = GetCodecManager()->codecs;
  return 0;
}

ArchiveUpdater *CodecManager::CreateUpdater(const ArchiveHandler *handler)
{
  return 0;
}

CCodecs *CodecManager::GetCodecs()
{
  return GetCodecManager()->codecs;
}

const ArchiveHandler &CodecManager::GetHandler(ArchiveHandlerIndex index)
{
  assert(0 <= index && index < static_cast<ArchiveHandlerIndex>(GetCodecManager()->handlers.size()));
  return GetCodecManager()->handlers[index];
}

CodecManager *CodecManager::GetCodecManager()
{
  if (sCodecManager == 0)
    sCodecManager = new szpp::CodecManager();
  return sCodecManager;
}

CodecManager::CodecManager() : handlers(), codecs(new CCodecs)
{
  codecs->AddRef();
  codecs->Load();

  // コーデックがロードできなかったのではこれ以上処理を続けられないので、例外を送出。
  if (codecs->Formats.Size() == 0)
  {
    codecs->Release();
    codecs = 0;
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot load codecs")));
  }

  // ハンドラの情報を構築
  for (int i = 0; i < codecs->Formats.Size(); ++i)
  {
    const CArcInfoEx &ai = codecs->Formats[i];
    handlers.push_back(new ArchiveHandler(i, ai));
  }
}

CodecManager::~CodecManager()
{
  if (codecs)
    codecs->Release();
}

SZ_NS_END(szpp)
